document["addEventListener"]("DOMContentLoaded",function(){const commandInput=document["getElementById"]("vds-command");const terminalContent=document["getElementById"]("terminal-content");const fileSystemContent=document["getElementById"]("file-system-content");const currentDirectoryElement=document["getElementById"]("current-directory");const connectedIpElement=document["getElementById"]("connected-ip");const traceLevelElement=document["getElementById"]("trace-level");const traceLevelFill=document["getElementById"]("trace-level-fill");const timerElement=document["getElementById"]("timer");const timerCountdown=document["getElementById"]("timer-countdown");const disconnectButton=document["getElementById"]("disconnect-button");const networkMap=document["getElementById"]("network-map");const fileViewer=document["getElementById"]("file-viewer");const fileViewerTitle=document["getElementById"]("file-viewer-title");const fileViewerContent=document["getElementById"]("file-viewer-content");const closeFileViewer=document["getElementById"]("close-file-viewer");const refreshDirectory=document["getElementById"]("refresh-directory");const cpuFill=document["querySelector"](".cpu-fill");const ramFill=document["querySelector"](".ram-fill");const diskFill=document["querySelector"](".disk-fill");const cpuValue=document["querySelector"](".cpu-value");const ramValue=document["querySelector"](".ram-value");const diskValue=document["querySelector"](".disk-value");let commandHistory=[];let historyIndex=-1;let lastViewedFile=null;waitForLanguageManager()["then"](()=>{checkSSHBeforeInit()});function checkSSHBeforeInit(){const missionId=window["CURRENT_MISSION_ID"];const currentIp=connectedIpElement?connectedIpElement["textContent"]:null;if(!missionId||!currentIp){initVDS();return}fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=check_ssh_required",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId+"&target_ip="+currentIp})["then"](response=>{return response["json"]()})["then"](data=>{if(data["ssh_required"]===true){showSSHPopupBeforeInit(currentIp)}else{initVDS()}})["catch"](error=>{console["log"]("SSH check error, initializing anyway:",error);initVDS()})}function showSSHPopupBeforeInit(targetIp){const overlay=document["createElement"]("div");overlay["id"]="ssh-init-overlay";overlay["style"]["cssText"]="\n            position: fixed;\n            top: 0;\n            left: 0;\n            width: 100%;\n            height: 100%;\n            background: rgba(0, 0, 0, 0.7);\n            display: flex;\n            align-items: center;\n            justify-content: center;\n            z-index: 10000;\n        ";const popup=document["createElement"]("div");popup["style"]["cssText"]="\n            background: #ECE9D8;\n            border: 3px solid #0054E3;\n            border-radius: 8px 8px 0 0;\n            width: 380px;\n            box-shadow: 0 2px 10px rgba(0,0,0,0.5);\n            font-family: 'Tahoma', 'Arial', sans-serif;\n        ";popup["innerHTML"]="\n            <div style=\"\n                background: linear-gradient(to right, #0054E3, #3F8CF3);\n                padding: 6px 8px;\n                border-radius: 5px 5px 0 0;\n                display: flex;\n                align-items: center;\n                justify-content: space-between;\n            \">\n                <span style=\"color: white; font-weight: bold; font-size: 13px;\">SSH</span>\n            </div>\n            <div style=\"padding: 20px;\">\n                <div style=\"margin-bottom: 15px;\">\n                    <label style=\"display: block; margin-bottom: 5px; font-size: 11px; color: #000;\">\n                        Username:\n                    </label>\n                    <input type=\"text\" id=\"ssh-init-username\" style=\"\n                        width: 100%;\n                        padding: 4px;\n                        border: 1px solid #7F9DB9;\n                        box-sizing: border-box;\n                        font-size: 11px;\n                    \" />\n                </div>\n                <div style=\"margin-bottom: 15px;\">\n                    <label style=\"display: block; margin-bottom: 5px; font-size: 11px; color: #000;\">\n                        Password:\n                    </label>\n                    <input type=\"password\" id=\"ssh-init-password\" style=\"\n                        width: 100%;\n                        padding: 4px;\n                        border: 1px solid #7F9DB9;\n                        box-sizing: border-box;\n                        font-size: 11px;\n                    \" />\n                </div>\n                <div id=\"ssh-init-error\" style=\"color: #DC143C; margin-bottom: 10px; font-size: 11px; display: none;\"></div>\n                <div style=\"display: flex; gap: 8px; justify-content: flex-end;\">\n                    <button id=\"ssh-init-connect-btn\" style=\"\n                        padding: 5px 20px;\n                        background: #000;\n                        color: #fff;\n                        border: 1px solid #003C74;\n                        cursor: pointer;\n                        font-size: 11px;\n                        min-width: 75px;\n                    \">OK</button>\n                </div>\n            </div>\n        ";overlay["appendChild"](popup);document["body"]["appendChild"](overlay);setTimeout(()=>{document["getElementById"]("ssh-init-username")["focus"]()},100);document["getElementById"]("ssh-init-connect-btn")["addEventListener"]("click",()=>{const username=document["getElementById"]("ssh-init-username")["value"]["trim"]();const password=document["getElementById"]("ssh-init-password")["value"];const errorDiv=document["getElementById"]("ssh-init-error");if(!username||!password){errorDiv["textContent"]=window["langManager"]["t"]("vds.ssh_credentials_required","Username and password are required");errorDiv["style"]["display"]="block";return}document["getElementById"]("ssh-init-connect-btn")["textContent"]=window["langManager"]["t"]("vds.ssh_connecting","Connecting...");document["getElementById"]("ssh-init-connect-btn")["disabled"]=true;errorDiv["style"]["display"]="none";fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=ssh_authenticate",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+window["CURRENT_MISSION_ID"]+"&target_ip="+targetIp+"&username="+encodeURIComponent(username)+"&password="+encodeURIComponent(password)})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){document["body"]["removeChild"](overlay);initVDS()}else{errorDiv["textContent"]=data["message"]||window["langManager"]["t"]("vds.ssh_authentication_failed","Authentication failed");errorDiv["style"]["display"]="block";document["getElementById"]("ssh-init-connect-btn")["textContent"]="OK";document["getElementById"]("ssh-init-connect-btn")["disabled"]=false}})["catch"](error=>{errorDiv["textContent"]=window["langManager"]["t"]("vds.ssh_connection_error","Connection error");errorDiv["style"]["display"]="block";document["getElementById"]("ssh-init-connect-btn")["textContent"]="OK";document["getElementById"]("ssh-init-connect-btn")["disabled"]=false})});document["getElementById"]("ssh-init-password")["addEventListener"]("keypress",e=>{if(e["key"]==="Enter"){document["getElementById"]("ssh-init-connect-btn")["click"]()}});document["getElementById"]("ssh-init-username")["addEventListener"]("keypress",e=>{if(e["key"]==="Enter"){document["getElementById"]("ssh-init-password")["focus"]()}})}function initVDS(){const vdsCommands=["help","ls","dir","cd","cat","rm","cp","corrupt","connect","disconnect","modify","sed","ping","/decrypt_tool"];let autocompleteIndex=0;let lastAutocompleteInput="";let autocompleteMatches=[];commandInput["addEventListener"]("keydown",e=>{if(e["key"]==="Tab"){e["preventDefault"]();e["stopPropagation"]();const val=commandInput["value"];const caret=commandInput["selectionStart"];const left=val["slice"](0,caret);const token=left["split"](new RegExp("\\s+",""))["pop"]()||"";const inputBase=token["toLowerCase"]()["trim"]();const isNewAutocomplete=!autocompleteMatches["some"](match=>{return match["toLowerCase"]()===inputBase});if(isNewAutocomplete){autocompleteIndex=0;lastAutocompleteInput=inputBase;const lowerInput=inputBase;autocompleteMatches=vdsCommands["filter"](cmd=>{const c=cmd["toLowerCase"]();if(c["startsWith"](lowerInput)){return true}if(c["startsWith"]("/")&&c["slice"](1)["startsWith"](lowerInput)){return true}return false})["sort"]()}if(autocompleteMatches["length"]===0){return}const match=autocompleteMatches[autocompleteIndex];const right=val["slice"](caret);const parts=left["split"](new RegExp("\\s+",""));parts[parts["length"]-1]=match;const newLeft=parts["join"](" ");commandInput["value"]=(newLeft+(right?" "+right:""))["trim"]();autocompleteIndex=(autocompleteIndex+1)%autocompleteMatches["length"];const newPos=newLeft["length"];setTimeout(()=>{commandInput["selectionStart"]=commandInput["selectionEnd"]=newPos},0)}else{if(e["key"]==="Escape"){autocompleteMatches=[];autocompleteIndex=0;lastAutocompleteInput=""}}},true);initFileSystem();setupNetwork();initSystemMetrics();initVPN()}disconnectButton["addEventListener"]("click",function(){disconnect()});refreshDirectory["addEventListener"]("click",function(){loadFileSystem(false)});closeFileViewer["addEventListener"]("click",function(){clearFileViewer()});async function waitForLanguageManager(){if(window["langManager"]&&window["langManager"]["translations"]&&Object["keys"](window["langManager"]["translations"])["length"]>0&&window["langManager"]["translations"]["vds"]){console["log"]("Language manager is already ready");return}return new Promise(resolve=>{const checkLanguageManager=()=>{if(window["langManager"]&&window["langManager"]["translations"]&&Object["keys"](window["langManager"]["translations"])["length"]>0&&window["langManager"]["translations"]["vds"]){console["log"]("Language manager is now ready");resolve()}else{console["log"]("Waiting for language manager...");setTimeout(checkLanguageManager,100)}};checkLanguageManager()})}function t(key,defaultText,params={}){if(window["langManager"]&&window["langManager"]["translations"]){const result=window["langManager"]["translate"](key,params);if(result===key&&defaultText){if(typeof defaultText==="string"&&params&&Object["keys"](params)["length"]>0){let text=defaultText;for(const[param,value]of Object["entries"](params)){text=text["replace"](new RegExp("\\{"+param+"\\}","g"),value)}return text}return defaultText}return result}if(typeof defaultText==="string"&&params&&Object["keys"](params)["length"]>0){let result=defaultText;for(const[param,value]of Object["entries"](params)){result=result["replace"](new RegExp("\\{"+param+"\\}","g"),value)}return result}return defaultText||key}function initSystemMetrics(){updateSystemMetrics();setInterval(updateSystemMetrics,3000)}let lastMissionStatus=null;function checkMissionStatus(){const missionId=window["CURRENT_MISSION_ID"];if(!missionId){return}fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=get_status",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){const statusLight=document["getElementById"]("mission-status-light");if(!statusLight){return}const isCompleted=data["status"]===2||data["status"]==="2";if(isCompleted&&lastMissionStatus!==2){statusLight["classList"]["add"]("completed");const successSound=new Audio((window["ASSETS_URL"]||window["BASE_URL"]+"/assets")+"/sounds/vds_success.wav");successSound["volume"]=0.2;successSound["play"]()["catch"](()=>{});try{showBitParticlesBadge()}catch(e){}}else{if(isCompleted){statusLight["classList"]["add"]("completed")}else{statusLight["classList"]["remove"]("completed")}}lastMissionStatus=data["status"]}})["catch"](error=>{})}if(window["CURRENT_MISSION_ID"]){setInterval(checkMissionStatus,3000);setTimeout(checkMissionStatus,1000)}function updateSystemMetrics(){const baselineCpu=Math["floor"](Math["random"]()*30)+10;const randomCpu=baselineCpu+Math["floor"](Math["random"]()*20);const cpuUsage=Math["min"](randomCpu,100);const baselineRam=Math["floor"](Math["random"]()*20)+40;const randomRam=baselineRam+Math["floor"](Math["random"]()*15);const ramUsage=Math["min"](randomRam,100);const baselineDisk=Math["floor"](Math["random"]()*10)+55;const randomDisk=baselineDisk+Math["floor"](Math["random"]()*5);const diskUsage=Math["min"](randomDisk,100);cpuFill["style"]["width"]=""+cpuUsage+"%";ramFill["style"]["width"]=""+ramUsage+"%";diskFill["style"]["width"]=""+diskUsage+"%";cpuValue["textContent"]=""+cpuUsage+"%";ramValue["textContent"]=""+ramUsage+"%";diskValue["textContent"]=""+diskUsage+"%";if(cpuUsage>80){cpuFill["style"]["backgroundColor"]="var(--danger-color)"}else{if(cpuUsage>60){cpuFill["style"]["backgroundColor"]="var(--warning-color)"}else{cpuFill["style"]["backgroundColor"]="var(--success-color)"}}if(commandHistory["length"]>0&&Math["random"]()>0.7){const spikeCpu=Math["min"](cpuUsage+Math["floor"](Math["random"]()*30)+10,100);setTimeout(()=>{cpuFill["style"]["width"]=""+spikeCpu+"%";cpuValue["textContent"]=""+spikeCpu+"%";if(spikeCpu>80){cpuFill["style"]["backgroundColor"]="var(--danger-color)"}else{if(spikeCpu>60){cpuFill["style"]["backgroundColor"]="var(--warning-color)"}}setTimeout(()=>{cpuFill["style"]["width"]=""+cpuUsage+"%";cpuValue["textContent"]=""+cpuUsage+"%";if(cpuUsage>80){cpuFill["style"]["backgroundColor"]="var(--danger-color)"}else{if(cpuUsage>60){cpuFill["style"]["backgroundColor"]="var(--warning-color)"}else{cpuFill["style"]["backgroundColor"]="var(--success-color)"}}},800)},200)}}function showBitParticlesBadge(){if(document["getElementById"]("vds-badge-overlay")){return}const overlay=document["createElement"]("div");overlay["id"]="vds-badge-overlay";overlay["className"]="vds-badge-overlay";document["body"]["appendChild"](overlay);const badge=document["createElement"]("div");badge["className"]="vds-badge";badge["innerHTML"]="\n                <div class=\"vds-badge-wrap\">\n                  <svg viewBox=\"0 0 120 120\" xmlns=\"http://www.w3.org/2000/svg\" aria-hidden=\"true\">\n                      <defs>\n                        <linearGradient id=\"g1\" x1=\"0\" x2=\"1\">\n                          <stop offset=\"0%\" stop-color=\"#00FFC6\"/>\n                          <stop offset=\"100%\" stop-color=\"#00A3FF\"/>\n                        </linearGradient>\n                      </defs>\n                      <circle cx=\"60\" cy=\"60\" r=\"46\" fill=\"url(#g1)\" stroke=\"#0A0A0A\" stroke-opacity=\"0.15\" stroke-width=\"2\"/>\n                      <g transform=\"translate(30,30) scale(0.8)\">\n                          <path d=\"M30 6 L37 22 L54 24 L41 36 L44 53 L30 44 L16 53 L19 36 L6 24 L23 22 Z\" fill=\"#fff\" opacity=\"0.96\" />\n                      </g>\n                  </svg>\n                  <div class=\"vds-badge-text\">"+(typeof t==="function"?t("missions_api.mission_completed_text","MISSION COMPLETED!"):"MISSION COMPLETED!")+"</div>\n                </div>\n            ";overlay["appendChild"](badge);requestAnimationFrame(()=>{setTimeout(()=>{return badge["classList"]["add"]("show")},20)});setTimeout(()=>{overlay["classList"]["add"]("fade-out");setTimeout(()=>{if(overlay&&overlay["parentNode"]){overlay["parentNode"]["removeChild"](overlay)}},700)},5000)}commandInput["addEventListener"]("keydown",function(e){if(e["key"]==="Enter"){const command=commandInput["value"]["trim"]();if(command){commandHistory["push"](command);historyIndex=commandHistory["length"];processCommand(command);commandInput["value"]=""}}else{if(e["key"]==="ArrowUp"){if(historyIndex>0){historyIndex--;commandInput["value"]=commandHistory[historyIndex]}e["preventDefault"]()}else{if(e["key"]==="ArrowDown"){if(historyIndex<commandHistory["length"]-1){historyIndex++;commandInput["value"]=commandHistory[historyIndex]}else{historyIndex=commandHistory["length"];commandInput["value"]=""}e["preventDefault"]()}}}});function initFileSystem(){currentDirectoryElement["textContent"]=currentDirectory;fileSystemContent["innerHTML"]="<div class=\"file-system-info\">"+t("vds.use_ls_command","Use \"ls\" command to view files and folders")+"</div>"}function processCommand(command){const commandEntry=document["createElement"]("div");commandEntry["className"]="command-entry";commandEntry["innerHTML"]="<div class=\"command\"><span class=\"vds-prompt\">root@"+currentIp["split"](".")[0]+":~$</span> "+command+"</div>";terminalContent["appendChild"](commandEntry);const responseElement=document["createElement"]("div");responseElement["className"]="command-response";let normalizedCommand=command["replace"](new RegExp("(^|\\s)cd\\.\\.(?=$|\\s)","ig"),"$1cd ..");normalizedCommand=normalizedCommand["replace"](new RegExp("(^|\\s)dir(?=$|\\s)","ig"),"$1ls");normalizedCommand=normalizedCommand["replace"](new RegExp("(^|\\s)rm\\*(?=$|\\s)","ig"),"$1rm *");const trimmedCommand=normalizedCommand["trim"]();const originalArgs=trimmedCommand["split"](" ");const baseCmd=originalArgs[0]["toLowerCase"]();const cmd=normalizedCommand["toLowerCase"]()["trim"]();const args=cmd["split"](" ");logCommand(command);switch(baseCmd){case"help":responseElement["innerHTML"]="\n                    <div class=\"help-content\">\n                    <div class=\"help-section\">\n                        <div class=\"help-command\">help</div><div class=\"help-desc\">"+t("vds.commands.help_desc","Show this help message")+"</div>\n                        <div class=\"help-command\">ls</div><div class=\"help-desc\">"+t("vds.commands.ls_desc","List files in current directory or specified path")+"</div>\n                        <div class=\"help-command\">cd [directory]</div><div class=\"help-desc\">"+t("vds.commands.cd_desc","Change directory")+"</div>\n                        <div class=\"help-command\">cat [file]</div><div class=\"help-desc\">"+t("vds.commands.cat_desc","View file contents")+"</div>\n                        <div class=\"help-command\">cp [file]</div><div class=\"help-desc\">"+t("vds.commands.cp_desc","Copy file to your system")+"</div>\n                        <div class=\"help-command\">rm [file]</div><div class=\"help-desc\">"+t("vds.commands.rm_desc","Delete file")+"</div>\n                        <div class=\"help-command\">corrupt [file]</div><div class=\"help-desc\">"+t("vds.commands.corrupt_desc","Corrupt file (destroy evidence)")+"</div>\n                        <div class=\"help-command\">modify [file]</div><div class=\"help-desc\">"+t("vds.commands.modify_desc","Modify file (plant backdoor)")+"</div>\n                        <div class=\"help-command\">sed [file] [old] [new]</div><div class=\"help-desc\">"+t("vds.commands.sed_desc","Modify file content (search and replace)")+"</div>\n                        <div class=\"help-command\">ping [ip]</div><div class=\"help-desc\">"+t("vds.commands.ping_desc","Send ping to target IP address")+"</div>\n                        <div class=\"help-command\">/decrypt_tool [file] [password]</div><div class=\"help-desc\">"+t("vds.commands.decrypt_desc","Decrypt encrypted file with password")+"</div>\n                        <div class=\"help-command\">disconnect</div><div class=\"help-desc\">"+t("vds.commands.disconnect_desc","Disconnect from current system")+"</div>\n                    </div>\n                    </div>\n                ";break;case"ls":if(originalArgs["length"]>1){const targetDir=originalArgs["slice"](1)["join"](" ");let newPath=targetDir;if(!newPath["startsWith"]("/")){if(currentDirectory==="/"){newPath="/"+newPath}else{newPath=""+currentDirectory+"/"+newPath}}newPath=normalizePath(newPath);currentDirectory=newPath;currentDirectoryElement["textContent"]=currentDirectory;loadFileSystem(true,currentDirectory);responseElement["innerHTML"]=t("vds.listing_files","Listing files in")+" "+currentDirectory}else{loadFileSystem(true);responseElement["innerHTML"]=t("vds.listing_files","Listing files in")+" "+currentDirectory}break;case"cd":if(args["length"]<2){responseElement["innerHTML"]=t("vds.usage_cd","Usage: cd [directory]")}else{changeDirectory(args[1])}break;case"cat":if(args["length"]<2){responseElement["innerHTML"]=t("vds.usage_cat","Usage: cat [file]")}else{catFile(args[1],responseElement);commandEntry["appendChild"](responseElement);return}break;case"rm":if(args["length"]<2){responseElement["innerHTML"]=t("vds.usage_rm","Usage: rm [file]")}else{if(args[1]==="*"){(async function(){responseElement["innerHTML"]=t("vds.deleting_all_files","Deleting all files in current directory...");commandEntry["appendChild"](responseElement);try{const dir=currentDirectory;const res=await fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=filesystem",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId+"&target_ip="+currentIp+"&directory="+dir});const data=await res["json"]();if(!data["success"]){responseElement["innerHTML"]=t("vds.error_loading_filesystem","Error loading file system.");responseElement["className"]="command-response danger";return}if(!data["files"]||data["files"]["length"]===0){responseElement["innerHTML"]=t("vds.no_files_found","No files found in this directory");return}for(const file of data["files"]){if(file["is_directory"]){continue}const fileResp=document["createElement"]("div");fileResp["className"]="command-response";fileResp["innerHTML"]=t("vds.deleting_file",{["filepath"]:file["name"]});commandEntry["appendChild"](fileResp);await rmFile(file["name"],fileResp)}loadFileSystem(false)}catch(e){responseElement["innerHTML"]=t("vds.error_deleting_file","Error deleting files.");responseElement["className"]="command-response danger"}})();return}rmFile(args[1],responseElement);commandEntry["appendChild"](responseElement);return}break;case"cp":if(args["length"]<2){responseElement["innerHTML"]=t("vds.usage_cp","Usage: cp [file] [destination]")}else{copyFile(args[1],args[2]||null,responseElement);commandEntry["appendChild"](responseElement);return}break;case"corrupt":if(args["length"]<2){responseElement["innerHTML"]=t("vds.usage_corrupt","Usage: corrupt [file]")}else{corruptFile(args[1],responseElement);commandEntry["appendChild"](responseElement);return}break;case"connect":if(args["length"]<2){responseElement["innerHTML"]=t("vds.usage_connect","Usage: connect [ip]")}else{connectToSystem(args[1]);return}break;case"disconnect":disconnect();return;case"modify":if(originalArgs["length"]<2){responseElement["innerHTML"]=t("vds.usage_modify","Usage: modify [file] [modification_code]")}else{const modPassword=originalArgs[2]||null;modifyFile(originalArgs[1],modPassword,responseElement);commandEntry["appendChild"](responseElement);return}break;case"sed":if(originalArgs["length"]<4){responseElement["innerHTML"]=t("vds.usage_sed","Usage: sed [file] [old_text] [new_text]")}else{sedFile(originalArgs[1],originalArgs[2],originalArgs[3],responseElement);commandEntry["appendChild"](responseElement);return}break;case"ping":if(args["length"]<2){responseElement["innerHTML"]=t("vds.usage_ping","Usage: ping [ip]")}else{pingTarget(args[1],responseElement);commandEntry["appendChild"](responseElement);return}break;case"sed":if(originalArgs["length"]<4){responseElement["innerHTML"]=t("vds.usage_sed","Usage: sed [file] [old_text] [new_text]")}else{sedFile(originalArgs[1],originalArgs[2],originalArgs[3],responseElement);commandEntry["appendChild"](responseElement);return}break;case"/decrypt_tool":if(originalArgs["length"]<2){responseElement["innerHTML"]=t("vds.usage_decrypt_tool","Usage: /decrypt_tool [filename] [password]");responseElement["className"]="command-response"}else{decryptWithTool(originalArgs[1],originalArgs[2]||null,responseElement);commandEntry["appendChild"](responseElement);return}break;default:responseElement["innerHTML"]=t("vds.command_not_recognized","Command not recognized: {command}",{["command"]:command})}commandEntry["appendChild"](responseElement);terminalContent["scrollTop"]=terminalContent["scrollHeight"]}function loadFileSystem(showInTerminal=false,directory=null){let directoryToUse=currentDirectory;if(directory){let newPath=directory;if(!newPath["startsWith"]("/")){if(currentDirectory==="/"){newPath="/"+newPath}else{newPath=""+currentDirectory+"/"+newPath}}directoryToUse=normalizePath(newPath)}fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=filesystem",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId+"&target_ip="+currentIp+"&directory="+directoryToUse})["then"](response=>{return response["json"]()})["then"](data=>{if(data["ssh_required"]===true){showSSHPopup(currentIp,showInTerminal);return}if(data["success"]){fileSystemContent["innerHTML"]="";if(data["files"]["length"]===0){fileSystemContent["innerHTML"]="<div class=\"file-system-info\">"+t("vds.no_files_found","No files found in this directory")+"</div>";return}if(directoryToUse!=="/"){const parentDir=document["createElement"]("div");parentDir["className"]="file directory";parentDir["innerHTML"]="..";fileSystemContent["appendChild"](parentDir)}data["files"]["forEach"](file=>{const fileElement=document["createElement"]("div");fileElement["className"]=file["is_directory"]?"file directory":"file";const permissionsSpan=document["createElement"]("span");permissionsSpan["className"]="file-permissions";permissionsSpan["textContent"]=file["permissions"]||"-rw-r--r--";fileElement["innerHTML"]=""+file["name"]+" "+(file["is_directory"]?"":"("+file["size"]+" KB)");fileElement["appendChild"](permissionsSpan);fileSystemContent["appendChild"](fileElement)});if(showInTerminal){let outputHtml="";const directories=data["files"]["filter"](file=>{return file["is_directory"]});const files=data["files"]["filter"](file=>{return!file["is_directory"]});directories["forEach"](dir=>{outputHtml+="<span class=\"info\">"+dir["name"]+"/</span>  "});files["forEach"](file=>{outputHtml+=""+file["name"]+"  "});const lsOutputElement=document["createElement"]("div");lsOutputElement["className"]="command-response";lsOutputElement["innerHTML"]=outputHtml;terminalContent["appendChild"](lsOutputElement);terminalContent["scrollTop"]=terminalContent["scrollHeight"]}}else{console["error"]("Error loading file system:",data["message"]);fileSystemContent["innerHTML"]="<div class=\"danger\">"+t("vds.error","Error")+": "+data["message"]+"</div>";if(showInTerminal){const errorElement=document["createElement"]("div");errorElement["className"]="command-response danger";errorElement["innerHTML"]=""+t("vds.error","Error")+": "+data["message"];terminalContent["appendChild"](errorElement);terminalContent["scrollTop"]=terminalContent["scrollHeight"]}}})["catch"](error=>{console["error"]("Error loading file system:",error);fileSystemContent["innerHTML"]="<div class=\"danger\">"+t("vds.error_loading_filesystem","Error loading file system.")+"</div>";if(showInTerminal){const errorElement=document["createElement"]("div");errorElement["className"]="command-response danger";errorElement["innerHTML"]=t("vds.error_loading_filesystem","Error loading file system.");terminalContent["appendChild"](errorElement);terminalContent["scrollTop"]=terminalContent["scrollHeight"]}})}function changeDirectory(directory){let newPath=directory;if(!directory["startsWith"]("/")){if(currentDirectory==="/"){newPath="/"+directory}else{newPath=""+currentDirectory+"/"+directory}}newPath=normalizePath(newPath);fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=update_directory",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId+"&directory="+newPath})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){currentDirectory=newPath;currentDirectoryElement["textContent"]=currentDirectory;loadFileSystem(false);const responseElement=document["createElement"]("div");responseElement["className"]="command-response";responseElement["innerHTML"]=t("vds.changed_directory","Changed directory to {directory}",{["directory"]:currentDirectory});terminalContent["appendChild"](responseElement);terminalContent["scrollTop"]=terminalContent["scrollHeight"]}else{const responseElement=document["createElement"]("div");responseElement["className"]="command-response danger";responseElement["innerHTML"]=data["message"]||t("vds.error_changing_directory","Error changing directory");terminalContent["appendChild"](responseElement);terminalContent["scrollTop"]=terminalContent["scrollHeight"]}})["catch"](error=>{console["error"]("Error changing directory:",error);const responseElement=document["createElement"]("div");responseElement["className"]="command-response danger";responseElement["innerHTML"]=t("vds.error_changing_directory","Error changing directory");terminalContent["appendChild"](responseElement);terminalContent["scrollTop"]=terminalContent["scrollHeight"]})}function normalizePath(path){const segments=path["split"]("/")["filter"](segment=>{return segment!==""});const result=[];for(const segment of segments){if(segment==="."){}else{if(segment===".."){result["pop"]()}else{result["push"](segment)}}}return"/"+result["join"]("/")}function catFile(filename,responseElement=null){let filePath=filename;if(!filename["startsWith"]("/")){if(currentDirectory==="/"){filePath="/"+filename}else{filePath=""+currentDirectory+"/"+filename}}lastViewedFile=filePath;fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=get_file_content",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId+"&target_ip="+currentIp+"&path="+filePath})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){if(!responseElement){responseElement=document["createElement"]("div");responseElement["className"]="command-response";terminalContent["appendChild"](responseElement)}responseElement["innerHTML"]=t("vds.displaying_file","Displaying file: {filePath}",{["filePath"]:filePath});displayFileInViewer(filePath,data["content"]);if(data["is_objective"]){const objectiveElement=document["createElement"]("div");objectiveElement["className"]="command-response success";objectiveElement["innerHTML"]=data["message"];terminalContent["appendChild"](objectiveElement)}terminalContent["scrollTop"]=terminalContent["scrollHeight"]}else{if(!responseElement){responseElement=document["createElement"]("div");responseElement["className"]="command-response danger";terminalContent["appendChild"](responseElement)}else{responseElement["className"]="command-response danger"}responseElement["innerHTML"]=data["message"]||t("vds.file_not_found","File not found");terminalContent["scrollTop"]=terminalContent["scrollHeight"]}})["catch"](error=>{console["error"]("Error reading file:",error);if(!responseElement){responseElement=document["createElement"]("div");responseElement["className"]="command-response danger";terminalContent["appendChild"](responseElement)}else{responseElement["className"]="command-response danger"}responseElement["innerHTML"]=t("vds.error_reading_file","Error reading file");terminalContent["scrollTop"]=terminalContent["scrollHeight"]})}function displayFileInViewer(filePath,content){fileViewerTitle["textContent"]=filePath;let formattedContent=content;if(filePath["endsWith"](".sql")||filePath["includes"]("db")){formattedContent=formatSQL(content)}else{if(filePath["endsWith"](".log")){formattedContent=formatLog(content)}else{if(filePath["endsWith"](".json")){formattedContent=formatJSON(content)}}}fileViewerContent["innerHTML"]="<pre>"+formattedContent+"</pre>"}function clearFileViewer(){fileViewerTitle["textContent"]=t("vds.vds_file_viewer","File Viewer");fileViewerContent["innerHTML"]="\n            <div style=\"text-align: center; color: var(--secondary-color);\">\n                "+t("vds.vds_no_file_selected","No file selected.")+"<br>\n                "+t("vds.vds_use_cat_command","Use {command} to view file contents.",{["command"]:"<span style=\"color: var(--accent-color)\">cat [filename]</span>"})+"\n            </div>\n        ";lastViewedFile=null}function formatSQL(content){return content["replace"](new RegExp("\\b(SELECT|INSERT|UPDATE|DELETE|FROM|WHERE|JOIN|ON|GROUP BY|ORDER BY|HAVING|CREATE|TABLE|ALTER|DROP|INDEX|CONSTRAINT|PRIMARY|KEY|FOREIGN|REFERENCES|ADD|COLUMN|SET|VALUES|AND|OR|AS|LIKE|BETWEEN|IN|NOT|NULL|TEXT|INTEGER|REAL|VARCHAR|CHAR|DATE|TIME|TIMESTAMP|BOOLEAN|DEFAULT)\\b","gi"),match=>{return"<span class=\"sql-keyword\">"+match+"</span>"})["replace"](new RegExp("('[^']*')","g"),match=>{return"<span class=\"sql-string\">"+match+"</span>"})["replace"](new RegExp("\\b(\\d+)\\b","g"),match=>{return"<span class=\"sql-number\">"+match+"</span>"})}function formatLog(content){return content["replace"](new RegExp("\\[(ERROR|WARN|WARNING|FATAL)\\]","gi"),match=>{return"<span class=\"danger\">"+match+"</span>"})["replace"](new RegExp("\\[(INFO|NOTICE)\\]","gi"),match=>{return"<span class=\"info\">"+match+"</span>"})["replace"](new RegExp("\\[(SUCCESS|OK)\\]","gi"),match=>{return"<span class=\"success\">"+match+"</span>"})["replace"](new RegExp("\\b(\\d{4}-\\d{2}-\\d{2}|\\d{2}:\\d{2}:\\d{2})\\b","g"),match=>{return"<span class=\"warning\">"+match+"</span>"})}function formatJSON(content){try{const obj=JSON["parse"](content);return JSON["stringify"](obj,null,2)["replace"](new RegExp("\"([^\"]+)\":","g"),"<span class=\"info\">\"$1\":</span>")["replace"](new RegExp(": \"([^\"]+)\"","g"),": <span class=\"success\">\"$1\"</span>")["replace"](new RegExp(": (\\d+)","g"),": <span class=\"warning\">$1</span>")}catch(e){return content}}function logCommand(command){fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=log_command",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId+"&target_ip="+currentIp+"&command="+command})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){updateTraceLevel(data["trace_level"]);if(data["timer_started"]&&!timerStarted){startTimer(data["timer_seconds"]);timerStarted=true}if(typeof loadVPNStatus==="function"){loadVPNStatus()}window["dispatchEvent"](new CustomEvent("vds-command-executed"))}else{console["error"]("Error logging command:",data["message"])}})["catch"](error=>{console["error"]("Error logging command:",error)})}function updateTraceLevel(level){traceLevelElement["textContent"]=""+level+"%";traceLevelFill["style"]["width"]=""+level+"%";if(level<50){traceLevelFill["style"]["backgroundColor"]="var(--success-color)"}else{if(level<75){traceLevelFill["style"]["backgroundColor"]="var(--warning-color)"}else{traceLevelFill["style"]["backgroundColor"]="var(--danger-color)"}}if(level>=100){setTimeout(()=>{showSecurityAlert(t("vds.security_blocked_access","Server firewall blocked our access."));failMission()},500)}}function startCountdown(endTime){const timerElement=document["getElementById"]("timer");const timerCountdown=document["getElementById"]("timer-countdown");if(!timerElement||!timerCountdown){return}timerElement["style"]["display"]="block";if(!(endTime instanceof Date)){endTime=new Date(endTime)}window["timerEndTime"]=endTime;window["timerStarted"]=true;function updateTimer(){const now=new Date()["getTime"]();const distance=endTime["getTime"]()-now;if(distance<0){timerCountdown["textContent"]="0:00";if(typeof window["showSecurityAlert"]==="function"){window["showSecurityAlert"](t("vds.security_blocked_access","Server firewall blocked our access."))}if(typeof window["failMission"]==="function"){window["failMission"]()}else{window["location"]["href"]=window["BASE_URL"]+"/src/utils/Index.php"}return}const minutes=Math["floor"](distance%(1000*60*60)/(1000*60));const seconds=Math["floor"](distance%(1000*60)/1000);timerCountdown["textContent"]=""+minutes+":"+(seconds<10?"0":"")+seconds;setTimeout(updateTimer,1000)}updateTimer()}function startTimer(seconds){timerElement["style"]["display"]="block";const endTime=new Date;endTime["setSeconds"](endTime["getSeconds"]()+seconds);window["timerEndTime"]=endTime;window["timerStarted"]=true;runCountdown()}function runCountdown(){if(!window["timerEndTime"]){return}const now=new Date()["getTime"]();const distance=window["timerEndTime"]["getTime"]()-now;const minutes=Math["floor"](distance%(1000*60*60)/(1000*60));const seconds=Math["floor"](distance%(1000*60)/1000);timerCountdown["textContent"]=""+minutes+":"+(seconds<10?"0":"")+seconds;if(distance<0){timerCountdown["textContent"]="0:00";showSecurityAlert(t("vds.security_blocked_access","Server firewall blocked our access."));failMission();return}setTimeout(runCountdown,1000)}function failMission(){const responseElement=document["createElement"]("div");responseElement["className"]="command-response danger";responseElement["innerHTML"]=t("vds.security_breach_alert","ALERT: Security breach detected! Connection terminated.");terminalContent["appendChild"](responseElement);showSecurityAlert(t("vds.security_blocked_access","Server firewall blocked our access."));terminalContent["scrollTop"]=terminalContent["scrollHeight"];fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=fail",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId})["then"](response=>{return response["json"]()})["then"](data=>{setTimeout(function(){if(window["parent"]&&window["parent"]!==window){window["parent"]["postMessage"]({["action"]:"closeVDS"},"*")}if(window["parent"]&&window["parent"]["closeVDS"]){window["parent"]["closeVDS"]()}},3000)})["catch"](error=>{console["error"]("Error failing mission:",error);setTimeout(function(){if(window["parent"]&&window["parent"]!==window){window["parent"]["postMessage"]({["action"]:"closeVDS"},"*")}if(window["parent"]&&window["parent"]["closeVDS"]){window["parent"]["closeVDS"]()}},3000)})}function showSecurityAlert(message){const alertOverlay=document["createElement"]("div");alertOverlay["style"]["position"]="fixed";alertOverlay["style"]["top"]="0";alertOverlay["style"]["left"]="0";alertOverlay["style"]["width"]="100%";alertOverlay["style"]["height"]="100%";alertOverlay["style"]["backgroundColor"]="rgba(0, 0, 0, 0.7)";alertOverlay["style"]["zIndex"]="1000";alertOverlay["style"]["display"]="flex";alertOverlay["style"]["justifyContent"]="center";alertOverlay["style"]["alignItems"]="center";const alertBox=document["createElement"]("div");alertBox["style"]["width"]="400px";alertBox["style"]["padding"]="20px";alertBox["style"]["backgroundColor"]="#0a0e14";alertBox["style"]["border"]="2px solid var(--danger-color)";alertBox["style"]["borderRadius"]="5px";alertBox["style"]["boxShadow"]="0 0 20px var(--danger-color)";alertBox["style"]["color"]="white";alertBox["style"]["textAlign"]="center";const icon=document["createElement"]("div");icon["innerHTML"]="\u26A0\uFE0F";icon["style"]["fontSize"]="48px";icon["style"]["marginBottom"]="10px";const title=document["createElement"]("h2");title["textContent"]=t("vds.security_alert_title","SECURITY ALERT");title["style"]["color"]="var(--danger-color)";title["style"]["marginBottom"]="15px";const messageEl=document["createElement"]("p");messageEl["textContent"]=message;messageEl["style"]["marginBottom"]="15px";const progressTracker=document["createElement"]("div");progressTracker["style"]["display"]="flex";progressTracker["style"]["justifyContent"]="center";progressTracker["style"]["gap"]="8px";progressTracker["style"]["marginTop"]="15px";for(let i=0;i<3;i++){const dot=document["createElement"]("div");dot["style"]["width"]="12px";dot["style"]["height"]="12px";dot["style"]["borderRadius"]="50%";dot["style"]["backgroundColor"]="var(--danger-color)";dot["style"]["animation"]="pulse 1s infinite "+i*0.3+"s";progressTracker["appendChild"](dot)}if(!document["getElementById"]("alert-keyframes")){const style=document["createElement"]("style");style["id"]="alert-keyframes";style["textContent"]="\n                @keyframes pulse {\n                    0% { opacity: 0.3; transform: scale(0.8); }\n                    50% { opacity: 1; transform: scale(1.2); }\n                    100% { opacity: 0.3; transform: scale(0.8); }\n                }\n                @keyframes shake {\n                    0%, 100% { transform: translateX(0); }\n                    10%, 30%, 50%, 70%, 90% { transform: translateX(-5px); }\n                    20%, 40%, 60%, 80% { transform: translateX(5px); }\n                }\n            ";document["head"]["appendChild"](style)}alertBox["style"]["animation"]="shake 0.5s";alertBox["appendChild"](icon);alertBox["appendChild"](title);alertBox["appendChild"](messageEl);alertBox["appendChild"](progressTracker);alertOverlay["appendChild"](alertBox);document["body"]["appendChild"](alertOverlay)}function disconnect(){fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=clear_ssh_session",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId+"&target_ip="+currentIp})["catch"](err=>{return console["log"]("SSH session clear error:",err)});const responseElement=document["createElement"]("div");responseElement["className"]="command-response";responseElement["innerHTML"]=t("vds.disconnecting","Disconnecting from system...");terminalContent["appendChild"](responseElement);terminalContent["scrollTop"]=terminalContent["scrollHeight"];const isInIframe=window["location"]["search"]["includes"]("iframe=1")||window["parent"]!==window;if(isInIframe){setTimeout(function(){try{window["parent"]["postMessage"]({["action"]:"closeVDS"},"*")}catch(e){console["log"]("Could not send message to parent, trying alternative method");try{const vdsWindow=window["parent"]["document"]["querySelector"](".vds-window");if(vdsWindow){vdsWindow["remove"]()}}catch(e2){console["log"]("Could not close VDS window")}}},1000)}else{fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=disconnect",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId+"&target_ip="+currentIp})["then"](response=>{return response["json"]()})["then"](data=>{if(data["attention_increased"]){console["log"]("Attention level increased by "+data["attention_change"]+" due to undeleted log files")}setTimeout(function(){window["location"]["href"]=window["BASE_URL"]+"/src/utils/Index.php"},1000)})["catch"](error=>{console["error"]("Error during disconnect:",error);setTimeout(function(){window["location"]["href"]=window["BASE_URL"]+"/src/utils/Index.php"},1000)})}}function setupNetwork(){networkMap["innerHTML"]="";createNetworkGrid();createActivityIndicator();const yourNode=document["createElement"]("div");yourNode["className"]="network-node you";yourNode["style"]["left"]="40px";yourNode["style"]["top"]="90px";const yourIcon=document["createElement"]("div");yourIcon["className"]="icon";const yourLabel=document["createElement"]("div");yourLabel["className"]="label";yourLabel["textContent"]="YOUR PC";const yourIp=document["createElement"]("div");yourIp["className"]="ip";yourIp["textContent"]="192.168.1.100";yourNode["appendChild"](yourIcon);yourNode["appendChild"](yourLabel);yourNode["appendChild"](yourIp);networkMap["appendChild"](yourNode);const targetNode=document["createElement"]("div");targetNode["className"]="network-node current";targetNode["style"]["left"]="180px";targetNode["style"]["top"]="90px";const targetIcon=document["createElement"]("div");targetIcon["className"]="icon";const targetLabel=document["createElement"]("div");targetLabel["className"]="label";targetLabel["textContent"]="SERVER";const targetIp=document["createElement"]("div");targetIp["className"]="ip";targetIp["textContent"]=currentIp;targetNode["appendChild"](targetIcon);targetNode["appendChild"](targetLabel);targetNode["appendChild"](targetIp);networkMap["appendChild"](targetNode);addPortScanEffect(targetNode);const connectionLine=document["createElement"]("div");connectionLine["className"]="network-line";connectionLine["style"]["left"]="60px";connectionLine["style"]["top"]="105px";connectionLine["style"]["width"]="120px";if(Math["random"]()>0.5){const firewall=document["createElement"]("div");firewall["className"]="firewall-indicator";firewall["style"]["left"]="40px";connectionLine["appendChild"](firewall)}addDataPackets(connectionLine,"upload");networkMap["appendChild"](connectionLine);const downloadLine=document["createElement"]("div");downloadLine["className"]="network-line";downloadLine["style"]["left"]="60px";downloadLine["style"]["top"]="115px";downloadLine["style"]["width"]="120px";addDataPackets(downloadLine,"download");networkMap["appendChild"](downloadLine);const connectionDetails=document["createElement"]("div");connectionDetails["className"]="network-connection";connectionDetails["innerHTML"]="<div style=\"position: absolute; top: 130px; left: 110px; font-size: 9px; color: var(--secondary-color);\">\n            SSH | 443/TCP | ENCRYPTED\n        </div>";networkMap["appendChild"](connectionDetails);const statusIndicator=document["createElement"]("div");statusIndicator["className"]="mission-status-indicator";statusIndicator["id"]="mission-status-indicator";const statusLight=document["createElement"]("div");statusLight["className"]="mission-status-light";statusLight["id"]="mission-status-light";statusIndicator["appendChild"](statusLight);networkMap["appendChild"](statusIndicator);setInterval(()=>{if(Math["random"]()>0.7){addNetworkBlip()}},2000)}function createNetworkGrid(){const gridContainer=document["createElement"]("div");gridContainer["style"]["position"]="absolute";gridContainer["style"]["top"]="0";gridContainer["style"]["left"]="0";gridContainer["style"]["right"]="0";gridContainer["style"]["bottom"]="0";gridContainer["style"]["zIndex"]="-2";gridContainer["style"]["opacity"]="0.2";for(let i=0;i<8;i++){const line=document["createElement"]("div");line["style"]["position"]="absolute";line["style"]["left"]="0";line["style"]["right"]="0";line["style"]["height"]="1px";line["style"]["top"]=""+25*i+"px";line["style"]["backgroundColor"]="var(--border-color)";gridContainer["appendChild"](line)}for(let i=0;i<10;i++){const line=document["createElement"]("div");line["style"]["position"]="absolute";line["style"]["top"]="0";line["style"]["bottom"]="0";line["style"]["width"]="1px";line["style"]["left"]=""+25*i+"px";line["style"]["backgroundColor"]="var(--border-color)";gridContainer["appendChild"](line)}networkMap["appendChild"](gridContainer)}function addDataPackets(line,direction){const packetCount=5;for(let i=0;i<packetCount;i++){const packet=document["createElement"]("div");packet["className"]="data-packet data-packet-"+direction;packet["style"]["animationDelay"]=""+i*0.5+"s";line["appendChild"](packet)}}function addPortScanEffect(node){const scanEffect=document["createElement"]("div");scanEffect["className"]="port-scan";scanEffect["style"]["left"]="0";scanEffect["style"]["top"]="0";node["appendChild"](scanEffect);setTimeout(()=>{scanEffect["style"]["opacity"]="0.3"},Math["random"]()*2000+1000)}function createActivityIndicator(){const activityBar=document["createElement"]("div");activityBar["className"]="activity-indicator";for(let i=0;i<5;i++){const blip=document["createElement"]("div");blip["className"]="activity-blip";activityBar["appendChild"](blip)}const activityLabel=document["createElement"]("span");activityLabel["textContent"]="NET";activityBar["appendChild"](activityLabel);networkMap["appendChild"](activityBar)}function addNetworkBlip(){const blip=document["createElement"]("div");blip["className"]="data-packet";blip["style"]["width"]="2px";blip["style"]["height"]="2px";blip["style"]["background"]="var(--secondary-color)";blip["style"]["boxShadow"]="0 0 2px var(--secondary-color)";blip["style"]["opacity"]="0.8";blip["style"]["position"]="absolute";blip["style"]["left"]=""+Math["random"]()*100+"%";blip["style"]["top"]=""+Math["random"]()*100+"%";blip["style"]["animation"]="blip-fade 1s forwards";if(!document["getElementById"]("blip-keyframes")){const style=document["createElement"]("style");style["id"]="blip-keyframes";style["textContent"]="\n                @keyframes blip-fade {\n                    0% { transform: scale(0); opacity: 0.8; }\n                    50% { transform: scale(1); opacity: 0.5; }\n                    100% { transform: scale(0); opacity: 0; }\n                }\n            ";document["head"]["appendChild"](style)}networkMap["appendChild"](blip);setTimeout(()=>{blip["remove"]()},1000)}function scanSystem(){document["getElementById"]("scan-modal")["style"]["display"]="block";document["getElementById"]("scan-loading")["style"]["display"]="flex";document["getElementById"]("scan-result")["style"]["display"]="none";setTimeout(function(){document["getElementById"]("scan-loading")["style"]["display"]="none";document["getElementById"]("scan-result")["style"]["display"]="block";document["getElementById"]("scan-result")["innerHTML"]=generateScanResults()},3000);document["getElementById"]("scan-modal-close")["onclick"]=function(){document["getElementById"]("scan-modal")["style"]["display"]="none"}}function generateScanResults(){let scanResults="";if(currentIp==="78.45.32.12"){scanResults="\n                PORT SCAN RESULTS FOR "+currentIp+"\n                -----------------------------\n                PORT     STATE   SERVICE\n                22/tcp   open    ssh\n                80/tcp   open    http\n                443/tcp  open    https\n                3306/tcp open    mysql\n\n                VULNERABILITY SCAN RESULTS\n                -------------------------\n                [MEDIUM] MySQL server appears to be using default credentials\n                [LOW] Web server running outdated Apache version\n                [INFO] SSH server configured correctly\n            "}else{if(currentIp==="192.168.1.58"){scanResults="\n                PORT SCAN RESULTS FOR "+currentIp+"\n                -----------------------------\n                PORT     STATE   SERVICE\n                135/tcp  open    msrpc\n                139/tcp  open    netbios-ssn\n                445/tcp  open    microsoft-ds\n                3389/tcp open    rdp\n\n                VULNERABILITY SCAN RESULTS\n                -------------------------\n                [HIGH] Remote Desktop Protocol (RDP) allows weak encryption\n                [MEDIUM] SMB service may allow enumeration\n                [INFO] Several non-critical Windows updates pending\n            "}else{if(currentIp==="10.0.5.22"){scanResults="\n                PORT SCAN RESULTS FOR "+currentIp+"\n                -----------------------------\n                PORT     STATE   SERVICE\n                22/tcp   open    ssh\n                80/tcp   open    http\n                443/tcp  open    https\n                8080/tcp open    http-alt\n\n                VULNERABILITY SCAN RESULTS\n                -------------------------\n                [HIGH] Web application on port 8080 may be vulnerable to SQL injection\n                [MEDIUM] TLS configuration on 443 uses outdated ciphers\n                [LOW] HTTP server leaks version information\n            "}else{scanResults="\n                PORT SCAN RESULTS FOR "+currentIp+"\n                -----------------------------\n                PORT     STATE   SERVICE\n                22/tcp   open    ssh\n                80/tcp   open    http\n\n                VULNERABILITY SCAN RESULTS\n                -------------------------\n                [MEDIUM] Some services may be using default credentials\n                [LOW] System may be running outdated software\n            "}}}return scanResults}function rmFile(filename,responseElement=null){let filePath=filename;if(!filename["startsWith"]("/")){if(currentDirectory==="/"){filePath="/"+filename}else{filePath=""+currentDirectory+"/"+filename}}responseElement["innerHTML"]=t("vds.deleting_file",{["filepath"]:filePath});return fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=rm_file",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId+"&target_ip="+currentIp+"&path="+filePath})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){responseElement["innerHTML"]=data["message"];responseElement["className"]="command-response success";loadFileSystem(false);if(lastViewedFile===filePath){clearFileViewer()}}else{responseElement["innerHTML"]=data["message"];responseElement["className"]="command-response danger"}terminalContent["scrollTop"]=terminalContent["scrollHeight"]})["catch"](error=>{console["error"]("Error deleting file:",error);responseElement["innerHTML"]=t("vds.error_deleting_file","Error deleting file.");responseElement["className"]="command-response danger";terminalContent["scrollTop"]=terminalContent["scrollHeight"]})}function corruptFile(filename,responseElement=null){let filePath=filename;if(!filename["startsWith"]("/")){if(currentDirectory==="/"){filePath="/"+filename}else{filePath=""+currentDirectory+"/"+filename}}responseElement["innerHTML"]=t("vds.corrupting_file","Corrupting file: "+filePath);fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=corrupt_file",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId+"&target_ip="+currentIp+"&path="+filePath})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){responseElement["innerHTML"]=data["message"];responseElement["className"]="command-response success";loadFileSystem(false)}else{responseElement["innerHTML"]=data["message"];responseElement["className"]="command-response danger"}terminalContent["scrollTop"]=terminalContent["scrollHeight"]})["catch"](error=>{console["error"]("Error corrupting file:",error);responseElement["innerHTML"]=t("vds.error_corrupting_file","Error corrupting file.");responseElement["className"]="command-response danger";terminalContent["scrollTop"]=terminalContent["scrollHeight"]})}function modifyFile(filename,password=null,responseElement=null){let filePath=filename;if(!filename["startsWith"]("/")){if(currentDirectory==="/"){filePath="/"+filename}else{filePath=""+currentDirectory+"/"+filename}}responseElement["innerHTML"]=t("vds.modifying_file",{["filepath"]:filePath});let requestBody="mission_id="+missionId+"&target_ip="+currentIp+"&path="+filePath;if(password){requestBody+="&password="+encodeURIComponent(password)}fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=modify_file",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:requestBody})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){responseElement["innerHTML"]=data["message"];responseElement["className"]="command-response success"}else{responseElement["innerHTML"]=data["message"];responseElement["className"]="command-response danger"}terminalContent["scrollTop"]=terminalContent["scrollHeight"]})["catch"](error=>{console["error"]("Error modifying file:",error);responseElement["innerHTML"]=t("vds.error_modifying_file","Error modifying file.");responseElement["className"]="command-response danger";terminalContent["scrollTop"]=terminalContent["scrollHeight"]})}function sedFile(filename,oldText,newText,responseElement=null){let filePath=filename;if(!filename["startsWith"]("/")){if(currentDirectory==="/"){filePath="/"+filename}else{filePath=""+currentDirectory+"/"+filename}}responseElement["innerHTML"]=t("vds.modifying_file_content","Modifying file content: "+filePath);fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=modify_content",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId+"&target_ip="+currentIp+"&path="+filePath+"&old_text="+encodeURIComponent(oldText)+"&new_text="+encodeURIComponent(newText)})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){responseElement["innerHTML"]=data["message"];responseElement["className"]="command-response success";if(data["filepath"]){setTimeout(()=>{const catCommand="cat "+filename;const commandDiv=document["createElement"]("div");commandDiv["className"]="command-entry";const promptSpan=document["createElement"]("span");promptSpan["className"]="command-prompt";promptSpan["innerHTML"]="<span class=\"user\">root</span>@<span class=\"ip\">"+currentIp+"</span>:~$ ";const commandSpan=document["createElement"]("span");commandSpan["className"]="command-text";commandSpan["textContent"]=catCommand;commandDiv["appendChild"](promptSpan);commandDiv["appendChild"](commandSpan);const catResponse=document["createElement"]("div");catResponse["className"]="command-response";terminalContent["appendChild"](commandDiv);commandDiv["appendChild"](catResponse);catFile(filename,catResponse)},300)}}else{responseElement["innerHTML"]=data["message"];responseElement["className"]="command-response danger"}terminalContent["scrollTop"]=terminalContent["scrollHeight"]})["catch"](error=>{console["error"]("Error modifying file content:",error);responseElement["innerHTML"]=t("vds.error_modifying_file","Error modifying file content.");responseElement["className"]="command-response danger";terminalContent["scrollTop"]=terminalContent["scrollHeight"]})}function copyFile(filename,destination,responseElement=null){let filePath=filename;if(!filename["startsWith"]("/")){if(currentDirectory==="/"){filePath="/"+filename}else{filePath=""+currentDirectory+"/"+filename}}fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=copy_file",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId+"&target_ip="+currentIp+"&path="+filePath})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){responseElement["innerHTML"]=data["message"]||t("vds.file_copied_successfully","File copied successfully.");responseElement["className"]="command-response success";if(data["trace_level"]!==undefined){updateTraceLevel(data["trace_level"])}terminalContent["scrollTop"]=terminalContent["scrollHeight"]}else{if(data["trace_exceeded"]){responseElement["innerHTML"]=data["message"];responseElement["className"]="command-response danger";terminalContent["scrollTop"]=terminalContent["scrollHeight"];setTimeout(()=>{const loadingDiv=document["createElement"]("div");loadingDiv["className"]="command-response";loadingDiv["innerHTML"]="<div style=\"margin: 10px 0;\">"+"<div style=\"color: #ff4444;\">SECURITY BREACH DETECTED</div>"+"<div style=\"margin: 5px 0;\">Terminating connection...</div>"+"<div style=\"background: #333; border: 1px solid #555; height: 20px; position: relative; overflow: hidden;\">"+"<div id=\"securityBar\" style=\"background: linear-gradient(90deg, #ff4444, #ff0000); height: 100%; width: 0%; transition: width 2s linear;\"></div>"+"</div>"+"</div>";terminalContent["appendChild"](loadingDiv);terminalContent["scrollTop"]=terminalContent["scrollHeight"];setTimeout(()=>{document["getElementById"]("securityBar")["style"]["width"]="100%"},100);setTimeout(()=>{window["parent"]["postMessage"]({["action"]:"closeVDS"},"*")},2200)},500)}else{responseElement["innerHTML"]=data["message"]||t("vds.error_copying_file","Error copying file.");responseElement["className"]="command-response danger";terminalContent["scrollTop"]=terminalContent["scrollHeight"]}}})["catch"](error=>{console["error"]("Error copying file:",error);responseElement["innerHTML"]=t("vds.error_copying_file","Error copying file.");responseElement["className"]="command-response danger";terminalContent["scrollTop"]=terminalContent["scrollHeight"]})}function connectToSystem(ip){const responseElement=document["createElement"]("div");responseElement["className"]="command-response danger";responseElement["innerHTML"]=t("vds.command_not_recognized","Command not recognized: {command}",{["command"]:"connect"});terminalContent["appendChild"](responseElement);terminalContent["scrollTop"]=terminalContent["scrollHeight"]}function runProgram(program,args,responseElement=null){responseElement["innerHTML"]=t("vds.attempting_run",{["program"]:program});setTimeout(()=>{if(program==="exploit"){responseElement["innerHTML"]=t("vds.running_exploit","Running exploit...\nAccess granted! Use 'cp' command to extract data.");responseElement["className"]="command-response success"}else{responseElement["innerHTML"]=t("vds.invalid_executable",{["program"]:program});responseElement["className"]="command-response danger"}terminalContent["scrollTop"]=terminalContent["scrollHeight"]},1000)}function bypassSecurity(target,responseElement=null){responseElement["innerHTML"]=t("vds.attempting_bypass",{["target"]:target});setTimeout(()=>{responseElement["innerHTML"]=t("vds.access_denied","Access denied: Additional authentication required.");responseElement["className"]="command-response danger";terminalContent["scrollTop"]=terminalContent["scrollHeight"]},1500)}function bruteForce(target,responseElement=null){responseElement["innerHTML"]=t("vds.initiating_brute_force",{["target"]:target});let progress=0;const interval=setInterval(()=>{progress+=10;responseElement["innerHTML"]=t("vds.brute_force_progress",{["progress"]:progress});if(progress>=100){clearInterval(interval);responseElement["innerHTML"]=t("vds.brute_force_failed","Brute force attack failed: Too many incorrect attempts detected.");responseElement["className"]="command-response danger";terminalContent["scrollTop"]=terminalContent["scrollHeight"]}},500)}function injectCode(target,responseElement=null){responseElement["innerHTML"]=t("vds.preparing_injection",{["target"]:target});setTimeout(()=>{responseElement["innerHTML"]=t("vds.injection_failed","Injection failed: Input validation preventing execution.");responseElement["className"]="command-response danger";terminalContent["scrollTop"]=terminalContent["scrollHeight"]},1200)}function setupProxy(ip,responseElement=null){responseElement["innerHTML"]=t("vds.setting_up_proxy",{["ip"]:ip});setTimeout(()=>{responseElement["innerHTML"]=t("vds.proxy_setup_failed","Proxy setup failed: Cannot establish connection to specified IP.");responseElement["className"]="command-response danger";terminalContent["scrollTop"]=terminalContent["scrollHeight"]},1000)}function pingTarget(targetIp,responseElement=null){const ipPattern=new RegExp("^(\\d{1,3}\\.){3}\\d{1,3}$","");if(!ipPattern["test"](targetIp)){responseElement["innerHTML"]="<span class=\"danger\">"+t("vds.invalid_ip","Invalid IP address format: {ip}",{["ip"]:targetIp})+"</span>";responseElement["className"]="command-response";terminalContent["scrollTop"]=terminalContent["scrollHeight"];return}responseElement["innerHTML"]=t("vds.pinging","Pinging {ip}...",{["ip"]:targetIp});fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=ping_target",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId+"&target_ip="+targetIp+"&current_ip="+currentIp})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){let output="<span class=\"success\">PING "+targetIp+"</span>\n";output+="64 bytes from "+targetIp+": icmp_seq=1 ttl=64 time=12.3 ms\n";output+="64 bytes from "+targetIp+": icmp_seq=2 ttl=64 time=11.8 ms\n";output+="64 bytes from "+targetIp+": icmp_seq=3 ttl=64 time=13.1 ms\n";output+="64 bytes from "+targetIp+": icmp_seq=4 ttl=64 time=14.2 ms\n\n";output+="--- "+targetIp+" ping statistics ---\n";output+="4 packets transmitted, 4 received, 0% packet loss\n";output+="<span class=\"success\">\u2713 "+t("vds.ping_successful","Target recorded")+"</span>";responseElement["innerHTML"]=output;responseElement["className"]="command-response"}else{let output="<span class=\"danger\">PING "+targetIp+"</span>\n";output+="Request timeout for icmp_seq 1\n";output+="Request timeout for icmp_seq 2\n";output+="Request timeout for icmp_seq 3\n";output+="Request timeout for icmp_seq 4\n\n";output+="--- "+targetIp+" ping statistics ---\n";output+="4 packets transmitted, 0 received, 100% packet loss\n";output+="<span class=\"danger\">\u2717 "+(data["message"]||t("vds.ping_failed","Target unreachable"))+"</span>";responseElement["innerHTML"]=output;responseElement["className"]="command-response"}terminalContent["scrollTop"]=terminalContent["scrollHeight"]})["catch"](error=>{console["error"]("Ping error:",error);responseElement["innerHTML"]="<span class=\"danger\">"+t("vds.ping_error","Network error occurred")+"</span>";responseElement["className"]="command-response";terminalContent["scrollTop"]=terminalContent["scrollHeight"]})}function decryptWithTool(filename,password,responseElement=null){let filePath=filename;if(!filename["startsWith"]("/")){if(currentDirectory==="/"){filePath="/"+filename}else{filePath=""+currentDirectory+"/"+filename}}responseElement["innerHTML"]=t("vds.executing_decrypt_tool",{["filepath"]:filePath});logCommand("/decrypt_tool "+filename+" "+password);fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=get_file_content",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId+"&target_ip="+currentIp+"&path="+filePath})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){if(filename["endsWith"](".enc")||filename["endsWith"](".encrypted")||filename["endsWith"](".pgp")||filename["endsWith"](".aes")){console["log"]("Password provided:",password);console["log"]("Password type:",typeof password);console["log"]("Password length:",password?password["length"]:0);const trimmedPassword=password?password["toString"]()["trim"]():"";let isCorrectPassword=false;if(trimmedPassword==="B$Pass2000"&&filename["includes"]("secret_recipe")){isCorrectPassword=true}else{if(trimmedPassword==="Archive2004"&&filename["includes"]("classified")){isCorrectPassword=true}else{if(trimmedPassword==="CryptoKey2005-MASTER-AES-2005-XK9P"&&filename["includes"]("vault_keys")){isCorrectPassword=true}}}if(isCorrectPassword){const decryptedFilename=filename["replace"](".enc",".txt")["replace"](".encrypted",".txt")["replace"](".pgp",".txt")["replace"](".aes",".txt");const decryptedPath=filePath["replace"](".enc",".txt")["replace"](".encrypted",".txt")["replace"](".pgp",".txt")["replace"](".aes",".txt");let decryptedContent="";if(filename["includes"]("vault_keys")){decryptedContent="CryptoBank Vault Master Access Codes - DECRYPTED\n\n=== MAIN VAULT ACCESS CODES ===\n\nPrimary Vault Code: 7834-9201-5566-3421\nBackup Vault Code: 2109-8756-4432-1098\nEmergency Override: 9999-0000-1111-2222\n\n=== SAFETY DEPOSIT BOX MASTER KEYS ===\n\nMaster Key A: SDK-2005-ALPHA-7834\nMaster Key B: SDK-2005-BETA-9201\nMaster Key C: SDK-2005-GAMMA-5566\n\n=== DIGITAL SIGNATURE CERTIFICATES ===\n\nRoot Certificate: CERT-CRYPTO-2005-ROOT\nSigning Authority: CERT-CRYPTO-2005-SIGN\nValidation Key: CERT-CRYPTO-2005-VALID\n\n=== TRANSACTION ENCRYPTION KEYS ===\n\nDomestic Transfers: TEK-DOM-2005-XK9P\nInternational Transfers: TEK-INTL-2005-YL3Q\nCryptocurrency: TEK-CRYPTO-2005-ZM7R\n\n=== CUSTOMER ACCOUNT ENCRYPTION ===\n\nAccount Database Key: ACCT-DB-2005-MASTER\nBackup Database Key: ACCT-DB-2005-BACKUP\nRecovery Key: ACCT-DB-2005-RECOVER\n\n=== TOTAL ASSETS PROTECTED ===\n\nMain Vault: $2,300,000,000\nSafety Deposit Boxes: $450,000,000\nDigital Currency: $500,000,000\nInternational Accounts: $1,800,000,000\n\nTOTAL: $5,050,000,000 (5.05 Billion USD)\n\n=== SECURITY NOTICE ===\n\nThis file provides complete access to all CryptoBank vault systems.\nUnauthorized access is a federal crime under 18 U.S.C. \xA7 1030.\nAll access attempts are logged and monitored by federal authorities.\n\nIn case of security breach, immediately contact:\n- FBI Cyber Crimes Division: 1-800-FBI-CYBER\n- Secret Service Financial Crimes: 1-800-SECRET-SERVICE\n- CryptoBank Security: security@cryptobank.com\n\n--- DECRYPTION SUCCESSFUL ---\n--- MISSION OBJECTIVE COMPLETED ---"}else{if(filename["includes"]("secret_recipe")){decryptedContent="# Secret Burger Recipe\n\nINGREDIENTS:\n- 500g premium ground beef\n- 2 tablespoons Worcestershire sauce\n- 1 teaspoon garlic powder\n- 1 teaspoon onion powder\n- Salt and pepper to taste\n- 4 slices of cheddar cheese\n- 4 brioche buns\n- Lettuce, tomato, pickles, onions\n- Special sauce (see below)\n\nSPECIAL SAUCE:\n- 1/4 cup mayonnaise\n- 2 tablespoons ketchup\n- 1 tablespoon mustard\n- 1 teaspoon pickle relish\n- Dash of hot sauce\n\nINSTRUCTIONS:\n1. Mix beef with Worcestershire sauce, garlic powder, onion powder, salt and pepper\n2. Form into 4 patties, slightly larger than the buns (they will shrink)\n3. Cook on high heat for 3-4 minutes each side for medium doneness\n4. Add cheese in the last minute of cooking\n5. Toast the brioche buns\n6. Mix all sauce ingredients\n7. Assemble burgers with sauce and toppings\n\nNOTE: This recipe is proprietary and should not be shared outside the company!"}else{if(filename["includes"]("classified")){decryptedContent="CLASSIFIED - TOP SECRET\nGovernment Archives - Decrypted Document\n\nOPERATION EAGLE MIDNIGHT - CLASSIFIED INTELLIGENCE REPORT\n\nDate: May 15, 2004\nClassification: TOP SECRET / NOFORN\nSubject: International Intelligence Operations\n\nSUMMARY:\nThis document contains highly classified information regarding ongoing intelligence operations,\nmilitary strategic plans, and diplomatic communications.\n\nCONTENTS:\n1. Military Operation Plans - European Theater\n2. Intelligence Reports - Middle East Operations\n3. Diplomatic Communications - Classified Negotiations\n4. Nuclear Facility Security Assessments\n5. CIA Operations - Deep Cover Assets\n6. NSA Surveillance Programs - Active Monitoring\n\nOPERATION DETAILS:\n- Operation code-named \"Eagle Midnight\"\n- 15 active field agents deployed\n- 8 foreign intelligence services compromised\n- $50M budget allocated for FY2004\n\nSECURITY NOTICE:\nThis document is classified TOP SECRET. Unauthorized disclosure is a federal crime\npunishable under 18 U.S.C. \xA7 793 (Espionage Act).\n\nAll personnel with access to this document must have Level 5 clearance.\n\nDOCUMENT ID: GOV-ARCH-2004-05-TS\nDECLASSIFICATION DATE: 2054-05-15"}else{decryptedContent="Decrypted file content appears here.\nThis file was successfully decrypted using the decrypt_tool."}}}fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=create_decrypted_file",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId+"&target_ip="+currentIp+"&encrypted_file="+filePath+"&decrypted_file="+decryptedPath+"&content="+encodeURIComponent(decryptedContent)})["then"](response=>{return response["json"]()})["then"](result=>{if(result["success"]){responseElement["innerHTML"]=t("vds.decryption_successful_created","Decryption successful! Created {filename}",{["filename"]:decryptedFilename});responseElement["className"]="command-response success";setTimeout(()=>{loadFileSystem()},500)}else{responseElement["innerHTML"]=t("vds.decryption_failed_password","Decryption failed: Incorrect password");responseElement["className"]="command-response danger"}})["catch"](error=>{responseElement["innerHTML"]=t("vds.decryption_failed_password","Decryption failed: Incorrect password");responseElement["className"]="command-response danger"})}else{responseElement["innerHTML"]=t("vds.decryption_failed_password","Decryption failed: Incorrect password");responseElement["className"]="command-response danger"}}else{responseElement["innerHTML"]=t("vds.not_encrypted_file",{["filename"]:filename});responseElement["className"]="command-response danger"}}else{responseElement["innerHTML"]=t("vds.file_not_found_error",{["filename"]:filename});responseElement["className"]="command-response danger"}terminalContent["scrollTop"]=terminalContent["scrollHeight"]})["catch"](error=>{responseElement["innerHTML"]=t("vds.error_during_decryption","An error occurred during decryption.");responseElement["className"]="command-response danger";terminalContent["scrollTop"]=terminalContent["scrollHeight"]})}function showSSHPopup(targetIp,showInTerminal=false){const overlay=document["createElement"]("div");overlay["style"]["cssText"]="\n            position: fixed;\n            top: 0;\n            left: 0;\n            width: 100%;\n            height: 100%;\n            background: rgba(0, 0, 0, 0.7);\n            display: flex;\n            align-items: center;\n            justify-content: center;\n            z-index: 10000;\n        ";const popup=document["createElement"]("div");popup["style"]["cssText"]="\n            background: #ECE9D8;\n            border: 3px solid #0054E3;\n            border-radius: 8px 8px 0 0;\n            width: 380px;\n            box-shadow: 0 2px 10px rgba(0,0,0,0.5);\n            font-family: 'Tahoma', 'Arial', sans-serif;\n        ";popup["innerHTML"]="\n            <div style=\"\n                background: linear-gradient(to right, #0054E3, #3F8CF3);\n                padding: 6px 8px;\n                border-radius: 5px 5px 0 0;\n                display: flex;\n                align-items: center;\n                justify-content: space-between;\n            \">\n                <span style=\"color: white; font-weight: bold; font-size: 13px;\">SSH</span>\n            </div>\n            <div style=\"padding: 20px;\">\n                <div style=\"margin-bottom: 15px;\">\n                    <label style=\"display: block; margin-bottom: 5px; font-size: 11px; color: #000;\">\n                        Username:\n                    </label>\n                    <input type=\"text\" id=\"ssh-username\" style=\"\n                        width: 100%;\n                        padding: 4px;\n                        border: 1px solid #7F9DB9;\n                        box-sizing: border-box;\n                        font-size: 11px;\n                    \" />\n                </div>\n                <div style=\"margin-bottom: 15px;\">\n                    <label style=\"display: block; margin-bottom: 5px; font-size: 11px; color: #000;\">\n                        Password:\n                    </label>\n                    <input type=\"password\" id=\"ssh-password\" style=\"\n                        width: 100%;\n                        padding: 4px;\n                        border: 1px solid #7F9DB9;\n                        box-sizing: border-box;\n                        font-size: 11px;\n                    \" />\n                </div>\n                <div id=\"ssh-error\" style=\"color: #DC143C; margin-bottom: 10px; font-size: 11px; display: none;\"></div>\n                <div style=\"display: flex; gap: 8px; justify-content: flex-end;\">\n                    <button id=\"ssh-connect-btn\" style=\"\n                        padding: 5px 20px;\n                        background: #000;\n                        color: #fff;\n                        border: 1px solid #003C74;\n                        cursor: pointer;\n                        font-size: 11px;\n                        min-width: 75px;\n                    \">OK</button>\n                </div>\n            </div>\n        ";overlay["appendChild"](popup);document["body"]["appendChild"](overlay);setTimeout(()=>{document["getElementById"]("ssh-username")["focus"]()},100);document["getElementById"]("ssh-connect-btn")["addEventListener"]("click",()=>{const username=document["getElementById"]("ssh-username")["value"]["trim"]();const password=document["getElementById"]("ssh-password")["value"];const errorDiv=document["getElementById"]("ssh-error");if(!username||!password){errorDiv["textContent"]=window["langManager"]["t"]("vds.ssh_credentials_required","Username and password are required");errorDiv["style"]["display"]="block";return}document["getElementById"]("ssh-connect-btn")["textContent"]=window["langManager"]["t"]("vds.ssh_connecting","Connecting...");document["getElementById"]("ssh-connect-btn")["disabled"]=true;errorDiv["style"]["display"]="none";fetch(window["BASE_URL"]+"/src/api/MissionApi.php?action=ssh_authenticate",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded"},["body"]:"mission_id="+missionId+"&target_ip="+targetIp+"&username="+encodeURIComponent(username)+"&password="+encodeURIComponent(password)})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){document["body"]["removeChild"](overlay);const successElement=document["createElement"]("div");successElement["className"]="command-response success";successElement["innerHTML"]=window["langManager"]["t"]("vds.ssh_connected_welcome","SSH: Connected to {ip}<br>Welcome, {username}!")["replace"]("{ip}",targetIp)["replace"]("{username}",username);terminalContent["appendChild"](successElement);terminalContent["scrollTop"]=terminalContent["scrollHeight"];loadFileSystem(showInTerminal)}else{errorDiv["textContent"]=data["message"]||window["langManager"]["t"]("vds.ssh_authentication_failed","Authentication failed");errorDiv["style"]["display"]="block";document["getElementById"]("ssh-connect-btn")["textContent"]="OK";document["getElementById"]("ssh-connect-btn")["disabled"]=false}})["catch"](error=>{errorDiv["textContent"]=window["langManager"]["t"]("vds.ssh_connection_error","Connection error. Please try again.");errorDiv["style"]["display"]="block";document["getElementById"]("ssh-connect-btn")["textContent"]="OK";document["getElementById"]("ssh-connect-btn")["disabled"]=false})});document["getElementById"]("ssh-password")["addEventListener"]("keypress",e=>{if(e["key"]==="Enter"){document["getElementById"]("ssh-connect-btn")["click"]()}});document["getElementById"]("ssh-username")["addEventListener"]("keypress",e=>{if(e["key"]==="Enter"){document["getElementById"]("ssh-password")["focus"]()}})}function initVPN(){const vpnContainer=document["getElementById"]("vpn-status-container");const vpnStatusText=document["getElementById"]("vpn-status-text");const vpnCapacityText=document["getElementById"]("vpn-capacity-text");const vpnToggleBtn=document["getElementById"]("vpn-toggle-btn");const vpnBar=document["querySelector"](".vpn-status-bar");if(!vpnContainer){return}loadVPNStatus();if(vpnToggleBtn){vpnToggleBtn["addEventListener"]("click",function(){toggleVPN()})}setInterval(loadVPNStatus,2000);window["addEventListener"]("vds-command-executed",function(){loadVPNStatus()})}function loadVPNStatus(){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=get_vpn_status"})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]&&data["vpn"]){updateVPNUI(data["vpn"])}})["catch"](error=>{console["error"]("VPN status error:",error)})}function updateVPNUI(vpnData){const vpnContainer=document["getElementById"]("vpn-status-container");const vpnStatusText=document["getElementById"]("vpn-status-text");const vpnCapacityText=document["getElementById"]("vpn-capacity-text");const vpnToggleBtn=document["getElementById"]("vpn-toggle-btn");const vpnBar=document["querySelector"](".vpn-status-bar");if(!vpnContainer){return}const isOwned=vpnData["vpn_owned"]==1;const isActive=vpnData["vpn_active"]==1;const capacity=vpnData["vpn_capacity"]||0;const maxCapacity=vpnData["vpn_max_capacity"]||30;if(isOwned){vpnContainer["style"]["display"]="block"}else{vpnContainer["style"]["display"]="none";return}if(vpnStatusText){vpnStatusText["textContent"]="VPN"}if(vpnCapacityText){vpnCapacityText["textContent"]=""+capacity+"/"+maxCapacity;if(capacity<=0){vpnCapacityText["style"]["color"]="var(--danger-color)"}else{if(capacity<=10){vpnCapacityText["style"]["color"]="var(--warning-color)"}else{vpnCapacityText["style"]["color"]="var(--success-color)"}}}if(vpnToggleBtn){if(capacity<=0){vpnToggleBtn["textContent"]=t("game.marketplace.vpn.depleted","Depleted");vpnToggleBtn["disabled"]=true;vpnToggleBtn["classList"]["remove"]("active")}else{vpnToggleBtn["disabled"]=false;if(isActive){vpnToggleBtn["textContent"]=t("game.marketplace.vpn.deactivate","Deactivate");vpnToggleBtn["classList"]["add"]("active")}else{vpnToggleBtn["textContent"]=t("game.marketplace.vpn.activate","Activate");vpnToggleBtn["classList"]["remove"]("active")}}}if(vpnBar){if(isActive){vpnBar["classList"]["add"]("active")}else{vpnBar["classList"]["remove"]("active")}}}function toggleVPN(){fetch(window["BASE_URL"]+"/src/utils/Index.php",{["method"]:"POST",["headers"]:{"Content-Type":"application/x-www-form-urlencoded","X-Requested-With":"XMLHttpRequest"},["body"]:"action=toggle_vpn"})["then"](response=>{return response["json"]()})["then"](data=>{if(data["success"]){const notification=document["createElement"]("div");notification["className"]="command-response";notification["style"]["color"]="var(--success-color)";notification["textContent"]=data["message"]||(data["vpn_active"]==1?"VPN activated":"VPN deactivated");terminalContent["appendChild"](notification);terminalContent["scrollTop"]=terminalContent["scrollHeight"];loadVPNStatus()}else{const errorNotif=document["createElement"]("div");errorNotif["className"]="command-response";errorNotif["style"]["color"]="var(--danger-color)";errorNotif["textContent"]=data["message"]||"VPN toggle failed";terminalContent["appendChild"](errorNotif);terminalContent["scrollTop"]=terminalContent["scrollHeight"]}})["catch"](error=>{console["error"]("VPN toggle error:",error)})}});